unit ProgressBar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;
//type Tapp = (mainmodel, fuzzycal);
type Tcprocedure = procedure of object;
type
  TFmProgress = class(TForm)
    PbRunStatus: TProgressBar;
    LblBegin: TLabel;
    LblEnd: TLabel;
    BtnCancel: TButton;
    procedure BtnCancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
//    apprunning: Tapp;
    CancelProcedure: Tcprocedure;
  end;

var
  FmProgress: TFmProgress;

implementation

uses stypes, frontend, display{, calmain};

{$R *.DFM}

procedure TFmProgress.BtnCancelClick(Sender: TObject);
begin
 if messageDlg('Do you want to abort this run?', mtConfirmation,
   [mbYes, mbNo], 0) = mrYes
 then
  begin
//   raise EUserCancel.Create('User canceled run. ');
{   if apprunning = mainmodel then
     FmShellMain.CancelRun
   else if apprunning = fuzzycal then
     FmCalMain.CancelRun;   }
    CancelProcedure;
  end;
end;

procedure TFmProgress.FormShow(Sender: TObject);
begin
  PbRunStatus.Position := 0;
{  FmProgress.Caption := modeldef.modelname + ' run progress';
  LblBegin.Caption := floattostr(time_start);
  LblEnd.Caption := floattostr(time_stop);  }
end;

procedure TFmProgress.FormCreate(Sender: TObject);
begin
 CancelProcedure := FmShellMain.CancelRun;
end;

end.
